/* Ogle - A video player
 * IR Control Client
 * Copyright (C) 2001-2004 Rossen Tchobanski <rosko@rosko.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <sys/msg.h>
#include <unistd.h>
#include <stdlib.h>

#include <ogle/dvdcontrol.h>
#include "actions.h"


#include <lirc/lirc_client.h>

#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>

#include <fcntl.h>

#define MAX_PID 65536

char *program_name;
int msgqid;

int bookmarks_autosave = 0;
int bookmarks_autoload = 0;


DVDNav_t *nav;
char *dvd_path;

int lirc_fd=-1;
struct lirc_config *config=NULL;

int isPaused;
double speed;
ZoomMode_t zoom_mode;

void usage()
{
  fprintf(stderr, "Usage: %s -m <msgid> [-v] [-h]\n", 
          program_name);
}

void version()
{
  fprintf(stderr, "%s version %s\n", 
          program_name, VERSION);
}

void cleanup()
{
  if(lirc_fd!=-1) {
  	  lirc_deinit();
  	  lirc_fd=-1;
  }
}

int get_mid()
{
  static char cmdbuf[64];
  char buf[32];
  int fd;
  ssize_t count;
  int mid; 

  int pid;

  for (pid=1; pid<MAX_PID; pid++) { 
    sprintf(buf,"/proc/%u/cmdline",pid);
    if( (( fd=open(buf,O_RDONLY) )) == -1) continue;
    count = read(fd, cmdbuf, sizeof(cmdbuf)-1);
    close(fd);
    if(count<1) continue;
    cmdbuf[count] = '\0';

    if(!isprint(cmdbuf[0])) continue;
    while(count--) if(!isprint(cmdbuf[count])) cmdbuf[count]=' ';

    if (!memcmp(cmdbuf,"ogle_nav",8)) { 
      sscanf(cmdbuf, "ogle_nav -m %d", &mid);	
      return mid;
    }
  }

  return (-1);
}

void init()
{
  DVDResult_t res;
  int i;
  
  if((lirc_fd=lirc_init("ogle",1))==-1) {
  	  fprintf(stderr,"%s: could not init LIRC support\n",
  		  program_name);
  	  return;
  }
  if(lirc_readconfig(NULL,&config,NULL)==-1) {
  	  lirc_deinit();
  	  fprintf(stderr,
  		  "%s: could not read LIRC config file\n"
  		  "%s: please read the documentation of LIRC \n"
  		  "%s: how to create a proper config file\n",
  		  program_name,program_name,program_name);
  	  return;
  }

  while((msgqid=get_mid())<0) i++;
  	  
  fprintf(stdout,"ogle_ir was bind with msgqid %d\n",msgqid);

  if(msgqid !=-1) { // ignore sending data.
    sleep(1);
    res = DVDOpenNav(&nav, msgqid);
    init_actions(nav);
    if(res != DVD_E_Ok ) {
      DVDPerror("DVDOpen:", res);
      exit(1);
    }
  }
}


int main(int argc, char *argv[])
{
  int c,n;
  int ret;	
  char *action;
  char *code; 
  int w, h;

  action_mapping_t *actions = get_action_mappings();

  program_name = argv[0];

  system("ogle &");

  init();
  

  while((ret=lirc_nextcode(&code))==0 && code!=NULL) {
    while((ret=lirc_code2char(config,code,&action))==0 && action!=NULL) {
#if DEBUG
       DNOTE("action %s\n", action);
#endif
      if (!strcmp("VOL_UP", action))
        system("aumix -w +5");
      if (!strcmp("VOL_DOWN", action))
	system("aumix -w -5");

      for(n = 0; actions[n].str != NULL; n++) {
        if(!strcmp(actions[n].str, action)) {
          if(actions[n].fun != NULL) {
            actions[n].fun(NULL);
          }
	  continue;
	}
      }	
    }
    free(code);
    if(ret==-1) break;
  }
  if(ret==-1) {
    /* something went badly wrong */
    fprintf(stderr,"%s: disconnected from LIRC\n",program_name);
    cleanup();
    exit(1);
  }

  return 0;
}
